package cn.ninegame.ad.demo.config;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.util.Log;

import androidx.annotation.Nullable;

import java.util.List;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.activity.MediationMainActivity;
import cn.ninegame.ad.demo.activity.PrivacyConfigActivity;
import cn.ninegame.ad.demo.util.PhoneInfoUtil;
import cn.ninegame.ad.demo.util.ToastUtil;
import cn.sirius.nga.NGAdSdk;
import cn.sirius.nga.NGAdSdk.Callback;
import cn.sirius.nga.ad.NGAdManager;
import cn.sirius.nga.config.LocationProvider;
import cn.sirius.nga.config.NGAdConfig;
import cn.sirius.nga.config.NGCustomController;

/**
 * 可以用一个单例来保存NGAdManager实例，在需要初始化sdk的时候调用
 */
public class NGAdManagerHolder {

    private static final String TAG = "NGAdManagerHolder";

    private static boolean sInit;
    private static boolean sStart;

    private NGAdManagerHolder() {

    }

    public static NGAdManager get() {
        return NGAdSdk.getAdManager();
    }

    public static void init(final Activity activity) {
        //初始化SDK
        doInit(activity);
    }

    //step1:接入网盟广告sdk的初始化操作，详情见接入文档和SDK平台说明
    private static void doInit(Activity activity) {
        if (sInit) {
            ToastUtil.show(activity, "您已经初始化过了");
            return;
        }
        //setp1.1：初始化SDK
        NGAdSdk.init(activity, buildConfig(activity), new Callback() {
            @Override
            public void success() {
                sInit = true;
                ToastUtil.show(activity, "初始化成功");
            }

            @Override
            public void fail(int code, String msg) {
                sInit = false;
                ToastUtil.show(activity, "初始化失败 code = " + code + " msg = " + msg);
            }
        });

    }

    public static void start(Context context) {
        if (!sInit) {
            ToastUtil.show(context, "还没初始化SDK，请先进行初始化");
            return;
        }
        if (sStart) {
            startActivity(context);
            return;
        }

        //setp1.2：启动SDK
        NGAdSdk.start(new Callback() {
            @Override
            public void success() {

                Log.i(TAG, "success: " + NGAdSdk.isSdkReady());
                startActivity(context);
            }

            @Override
            public void fail(int code, String msg) {
                sStart = false;
                Log.i(TAG, "fail:  code = " + code + " msg = " + msg);
            }
        });
        sStart = true;
    }

    public static void startActivity(Context context) {
        final Intent intent = new Intent(context, MediationMainActivity.class);
        context.startActivity(intent);
        ((Activity) context).finish();
    }


    private static NGAdConfig buildConfig(Activity activity) {

        return new NGAdConfig.Builder()
                /**
                 * 注：需要替换成在媒体平台申请的appID ，切勿直接复制
                 */
                .setAppId(activity.getResources().getString(R.string.ng_ad_app_id))
                .setAppName("APP测试媒体")
                /**
                 * 上线前需要关闭debug开关，否则会影响性能
                 */
                .setDebug(true)
                .setCustomController(getNGCustomController()) //如果您需要设置隐私策略请参考该api
                // .setExtraParams(NGAdConstant.SHOW_NOT_NETWORK_DIALOG_REWARD_VIDEO, false) // 激励视频：无网络引导弹窗，默认开启；如果关闭，游戏最好提供联网引导，以便顺利完成广告展示。
                .build();
    }


    /**
     * 函数返回值表示隐私开关开启状态，未重写函数使用默认值
     */
    private static NGCustomController getNGCustomController() {
        // 不需要自定配置，则直接使用默认配置
        if (!PrivacyConfigActivity.isHadCustomConfig()) {
            return new NGCustomController() {

            };
        }
        // 需要自定配，请查看PrivacyConfigActivity（仅为示例，非正式代码，请勿直接拷贝使用，需要根据具体情形进行自定义）
        return new NGCustomController() {

            @Override
            public boolean isCanUseLocation() {
                return PrivacyConfigActivity.isCanUseLocation();
            }

            @Override
            public boolean alist() {
                return PrivacyConfigActivity.isAppList();
            }

            @Override
            public boolean isCanUsePhoneState() {
                return PrivacyConfigActivity.isCanUsePhoneState();
            }

            @Nullable
            @Override
            public String getDevImei() {
                return super.getDevImei();
            }

            @Override
            public boolean isCanUseWifiState() {
                return PrivacyConfigActivity.isCanUseWifiState();
            }

            @Nullable
            @Override
            public String getMacAddress() {
                return PhoneInfoUtil.getMAC();
            }

            @Override
            public boolean isCanUseWriteExternal() {
                return PrivacyConfigActivity.isCanUseWriteExternal();
            }

            @Override
            public boolean isCanUseOaid() {
                return PrivacyConfigActivity.isCanUseOaid();
            }

            @Nullable
            @Override
            public String getDevOaid() {
                return PhoneInfoUtil.getOaid();
            }

            @Override
            public boolean isCanUseAndroidId() {
                return PrivacyConfigActivity.isCanUseAndroidId();
            }

            @Nullable
            @Override
            public String getAndroidId() {
                return PhoneInfoUtil.getAndroidId();
            }

            @Override
            public boolean isCanUsePermissionRecordAudio() {
                return PrivacyConfigActivity.isCanUsePermissionRecordAudio();
            }

            @Nullable
            @Override
            public LocationProvider getLocation() {
                Location gpsLocation = PhoneInfoUtil.getGpsLocation();
                if (gpsLocation == null) {
                    return null;
                } else {
                    return new LocationProvider() {
                        @Override
                        public double getLatitude() {
                            return gpsLocation.getLatitude();
                        }

                        @Override
                        public double getLongitude() {
                            return gpsLocation.getLongitude();
                        }
                    };
                }
            }

            @Nullable
            @Override
            public List<String> getCustomAppList() {
                return null;
            }

            @Override
            public boolean isLimitPersonalAds() {
                return PrivacyConfigActivity.isLimitPersonalAds();
            }

            @Override
            public boolean isProgrammaticRecommend() {
                return PrivacyConfigActivity.isProgrammaticRecommend();
            }
        };
    }
}
